Using MODIFY                                            The LeCroy 7200 Precision Oscilloscope is       controlled much like a conventional analog        oscilloscope. Traditional controls for            timebase, trigger and vertical gain and offset    are used. However, after these traditional        controls, the most important control on the       LeCroy 7200 Precision Oscilloscope is the         `MMODIFY`N key, located near the bottom-left      of the floppy disk drive. This key is used to     access nearly all user selectable features        associated with any other control knob, key or    softkey.                                                                                              For accessing advanced features, the            `MMODIFY`N key is the most important control      of the 7200 . The `MMODIFY`N key is used as a     prefix to (is pressed just before) another        control, and causes the 7200 to enter the         screen for setting options associated with        that control.                                                                                         For example: the `MHARDCOPY`N key initiates     a plot or printout, without prompting for the     various hardcopy options. In order to change      the hardcopy options, the `MMODIFY`N key is       pressed first, then the `MHARDCOPY`N key.         Subsequent presses of the `MHARDCOPY`N key use    the options chosen. In this case the key          initiates an action. The `MMODIFY`N key is        used to modify that action.                   Using Setup Screens                                     The principal controls for modifying            settings of the 7200 are the pair of              concentric knobs, located directly below the      center of the display. The detented knob          labelled, `MMove Box`N is used to move a small    box to each of the fields which can be            changed. The continuous knob, which is            commonly referred to as `MModify Value`N is       used to modify the value of the field             displayed in the box. The list of possible        values is shown on the screen in connection       with this knob.                                     To exit any menu, press the `MReturn`N          softkey, located near the lower left of the       display. Alternately, pressing `MCancel           Changes`N restores the values to their            previous state before exiting the menu.       Using Edit Text                                         If a screen contains text which may be          modified, the `MEdit Text`N label appears next    to the upper-left softkey when the box is         moved onto the text field. Pressing the `MEdit    Text`N softkey will cause the box to enclose      an individual character in the text field to      allow editting of the string letter-by-letter.  Modify Value                                          The `MModify Value`N continuous knob scrolls    through all allowable letters.                  Modify Field                                          The `MModify Field`N detented knob moves the    box from letter to letter.                      Insert Character                                      The `MInsert Character`N softkey adds a         character after the box.                        Delete Character                                      The `MDelete Character`N softkey deletes the    character surrounded by the box.                Default Text                                          The `MDefault Text`N softkey restores the       text which appears when default settings is       selected. For example, in the Trace Edit          screen, it is "TRACE1" for Trace 1, "TRACE2"      for Trace 2, and so on.                         Return                                                The `MReturn`N softkey keeps all changes        made to the text string and re-positions the      box on the entire text field.                   Cancel Changes                                        The `MCancel Changes`N softkey will cancel      all changes made to the text string since the     Edit Text key was pressed and re-positions the    box on the entire text field. Once `MReturn`N     or `MCancel Changes`N is selected, the            `MModify Field`N detented knob will move the      box onto the next field in the current menu.      To re-edit the text string, move the box onto     the text field and press the `MEdit Text`N        softkey.                                      Using Edit Arguments                                    Some screens, like the Extended Parameter       screen, have fields which require arguments to    further specify them. When the box is moved       onto such a field, the arguments will appear      at the bottom of the screen and the `MEdit        Arguments`N label will appear next to the         upper-left softkey. Pressing this softkey will    re-locate the box onto the arguments and allow    you to change them using the `MModify Value`N     continuous knob. The `MModify Field`N detented    knob will move the box from argument to           argument.                                       Return                                                The `MReturn`N softkey will keep all the        changes made to the arguments, remove the         cursor from the arguments and re-locate it        back to the original field.                     Cancel Changes                                        The `MCancel Changes`N softkey will cancel      all changes made to the arguments, restore the    value before `MEdit Arguments`N was pressed,      and relocate the box off the arguments field      and onto the original field.                  Displaying Traces                                       The fundamental purpose of the LeCroy 7200      Precision Oscilloscope is to display traces.      Up to 8 traces may be displayed                   simultaneously. If a trace is off, pressing       the `MTRACE`N key to the right of the display     turns the corresponding trace on. If the trace    is on, pressing the `MTRACE`N key makes it the    Selected trace as indicated by the rectangle      around its label. Pressing its key turns it       off.                                                While a trace is displayed, the on-screen       labeling next to the trace On/Off key             indicates the trace label, the horizontal and     vertical scaling per division or the cursor       values. Unless you specify a trace label, the     source of the data and a summary of any           processing on it is shown. Also, if needed,       the trace label is preceded by arrows             indicating if the trace is vertically and/or      horizontally expanded or repositioned.            Additional data associated with the trace may     also appear: the number of sweeps currently       being used in an average; or the number of the    segment being displayed, if one segment of a      segmented waveform is displayed.                    To change the trace's source or processing      you must press the `MMODIFY`N key and then the    `MTRACE`N key associated with the trace to        bring up its Trace Edit Screen. The source of     the traces may be either acquired data from a     digitizing channel or previously stored data.     Various processing functions, such as             averaging, smoothing, etc., may be applied to     the data before it is displayed.              Identifying Channels                                    Different 7200 plug-in types may have a         different number of channels. Data from each      acquisition channel is labeled according to:      the position of the plug-in used to acquire       the data, and the position of the BNC input       connector on the plug-in's front panel. The       plug-in slot in the mainframe closest to the      display is called the A-slot. The B-slot is       located to the right of A. For any plug-in        occupying slot-A, the uppermost left BNC          connector is channel A1. The next lower           connector is channel A2, and so on.           Front Panel Controls                                    Following are descriptions of the front         panel controls and the controls on the Main       screen which appears each time the 7200 is        turned on.                                    Using the On-line Help Manual                           The on-line Help Manual provides information    on manual control of the LeCroy 7200 Precision    Oscilloscope.                                       To display an explanation of any key,           softkey or knob, simply press the `MHELP`N        key, then press or turn that key or knob. Once    Help is displayed, there are several options      available.                                          The manual may be read like a book by using     the `MNext Topic`N and `MNext Line`N knobs at     the bottom of the display. The `MNext Topic`N     knob skips forward or backward in the manual      by topics, while the `MNext Line`N knob           scrolls forward or backward by lines.               The on-line Help Manual is divided into two     major sections, a table of contents and the       main text of the manual. When in the table of     contents, pressing the `MRead Topic`N softkey     will display the topic which is in the box at     the top of the display. When not in the table     of contents, pressing the `MTable of              Contents`N softkey will display the table of      contents.                                           While displaying the on-line Help, each         front panel control (other than Help softkeys)    gives direct access to the section of the         manual which describes that control. None of      these controls will affect the operation of       the 7200.                                           To exit Help, press the `MReturn`N softkey. Auto Setup                                              The `MAUTO SETUP`N key will automatically       set up the 7200 to display repetitive input       signals. Press this key to have the 7200          automatically set the timebase, trigger, and      vertical settings to fit the traces on the        display. `MAUTO SETUP`N does not change the       input's vertical coupling.                          `MAUTO SETUP`N sets up all channels which       are used in currently displayed traces.           Vertical settings are selected for each           channel individually. Timebase and trigger        settings for each plugin are adjusted for the     first channel on which a suitable repetitive      input signal is found.                              Signals detected must have an amplitude         between 2 mV and 8 V, frequency above 50 Hz,      and a duty cycle greater than 0.1%. `MAUTO        SETUP`N time depends on the signal frequency.     It is generally between 300 msec and 10 sec.        The `MTRIGGER MODE`N is set to NORMAL. If a     pure DC signal is found, the `MTRIGGER MODE`N     will be switched to AUTO and the Timebase set     to 10 sec.                                   Record Traces                                           The `MRecord Traces`N softkey automatically     records all displayed traces each time they       are updated with a new acquisition. Up to 4       Mbytes of the most recently displayed traces      are saved in a non-volatile circular buffer.        To start the automatic record process, press    the `MRecord Traces`N softkey on the 7200's       Main Screen. The softkey's label will change      to `MStop Record Traces`N and the `MREC`N icon    will be displayed at the bottom of the screen.      All traces which are turned on are recorded     each time they are updated on the screen. The     traces are saved in groups. For each              acquisition by a plug-in, all traces which        display or process data from that plug-in are     updated and recorded as a group. The number of    trace groups which are saved depends on the       number of points per trace and the number of      traces which are on. After the buffer is          filled, the oldest traces are overwritten.          To stop recording traces, press the `MStop      Record Traces`N softkey.                        Clearing the Record Traces Buffer                     The Record Traces buffer is non-volatile and    maintains its contents while the power is off.    However, it may be cleared and reset by           pressing the `MClear Memories`N softkey in the    System Configure Screen. NOTE: The `MClear        Memories`N softkey also clears the eight          internal memories M1...M8 (see description of     Waveform Storage).                            Replay Traces                                           The `MReplay Traces`N softkey retrieves         traces that `MRecord Traces`N saved in the        buffer. Replayed traces may be examined,          processed, or stored to floppy diskette. The      `MReplay Traces`N softkey is not present when     the Record Traces buffer is empty.                  To retrieve traces which have previously        been recorded, press the `MReplay Traces`N        softkey in the 7200's Main Screen. The            softkey's label will change to `MStop Replay      Traces`N and the `MPLAY`N icon will be            displayed at the bottom of the screen.              In Replay Traces mode, traces are retrieved     in the same groups in which they were             originally recorded. When the 7200 retrieves a    trace group, it puts the trace waveforms in       the corresponding memories M1...M8. For           example, if the 7200 retrieves a trace group      containing traces 1 and 2, the trace 1            waveform is put in memory M1 and the trace 2      waveform is put in memory M2, overwriting the     previous contents of the memories.                  In Replay Traces mode, the 7200 stops           acquiring data and switches from the              acquisition set of trace equations to the         replay set of trace equations. (Each trace is     defined by a mathematical trace equation which    specifies the source(s) of data and optional      processing.) The default values of the replay     trace equations are T1=M1, T2=M2,...T8=M8.        Thus, by default, all replayed trace waveforms    will be displayed in the same traces they         originally came from. The replay trace            equations may be modified in the Trace Setup      screens to perform processing on the replayed     waveforms in the memories. All operations         which can be performed on the acquisition         traces may be performed on the replay traces,     including waveform processing, vertical and       horizontal expansion and reposition, cursor       measurements, waveform parameters, and storage    to floppy diskette.                                 The 7200 provides sequential access to the      trace groups which have been recorded.            Softkeys are provided to step or scan backward    and forward in the Record Traces buffer. On       each step backward or forward the 7200            retrieves the group of traces recorded earlier    or later and places the waveforms in the          corresponding memories M1...M8. It                automatically turns on all traces which           display or process data from these memories       and turns off all other traces.                     The time at which the trace group was           originally recorded is displayed in the upper     left corner of the screen along with the index    of the trace group in the Record Traces           buffer. The most recently recorded group of       traces has index 0, the next older group index    -1, etc.                                            When Replay Traces mode is first turned on,     the 7200 retrieves the most recently recorded     trace group. The following softkeys provide       sequential access to the other recorded trace     groups:                                         Step Backward                                         Press the `MStep Backward`N softkey to          retrieve the group of traces which was            recorded previous to the current group. The       `MStep Backward`N softkey is not present when     there are no older trace groups.                Step Forward                                          Press the `MStep Forward`N softkey to           retrieve the group of traces which was            recorded after the current group. The `MStep      Forward`N softkey is not present when there       are no newer trace groups.                      Switch To Scan Mode                                   Press the `MSwitch To Scan Mode`N softkey to    switch from Step mode to Scan mode. The           softkey's label will change to `MSwitch To        Step Mode`N and the `MStep Backward`N and         `MStep Forward`N softkeys will change to          `MScan Backward`N and `MScan Forward.`N         Scan Backward                                         Press the `MScan Backward`N softkey to start    scanning backwards in the Record Traces           buffer. The 7200 will automatically retrieve,     display, and process (if configured in the        replay trace equations) successively older        trace groups. The softkey's label will change     to `MStop Scanning.`N Press it again to stop      scanning.                                       Scan Forward                                          Press the `MScan Forward`N softkey to start     scanning forward in the Record Traces buffer.     The 7200 will automatically retrieve, display,    and process (if configured in the replay trace    equations) successively newer trace groups.       The softkey's label will change to `MStop         Scanning.`N Press it again to stop scanning.    Switch To Step Mode                                   Press the `MSwitch To Step Mode`N softkey to    switch from Scan mode to Step mode. The           softkey's label will change to `MSwitch To        Scan Mode`N and the `MScan Backward`N and         `MScan Forward`N softkeys will change to          `MStep Backward`N and `MStep Forward.`N             To stop replaying recorded traces and resume    data acquisition, press the `MStop Replay         Traces`N softkey.                             Trigger Mode keys                                       These keys select Single, Auto, Normal, or      Sequence trigger modes for all input channels.    The trigger conditions (source, slope, etc.)      are independently selected for each plug-in.      As keys are pressed to step through each          Trigger Mode, LEDs indicate the mode selected.      Each mode operates as follows:                Single                                                Pressing `MTRIGGER MODE`N to select Single      arms the trigger circuit; that is, it starts      acquisition of the waveform data. When a valid    trigger signal is detected acquisition            completes and the waveform is displayed. To       arm the circuit again for another sweep, press    `MTRIGGER MODE`N again to re-select Single.       When a valid trigger is detected, the             acquisition completes and the new waveform        then replaces the one previously displayed.       Pressing the key before a valid trigger occurs    forces a trigger and causes the acquisition to    complete.                                       Normal                                                In Normal Trigger Mode, the 7200 re-arms the    trigger circuit and starts data acquisition       after each valid trigger. Normal mode updates     the display with newly acquired data after        each valid trigger is detected.                 Auto                                                  Auto Trigger Mode differs from Normal           Trigger Mode in one way: if a valid trigger       signal is not detected within 100 msec, an        internal trigger signal is generated.           Sequence                                              Sequence Trigger Mode partitions the            acquisition memory into 2, 5, 10, 20, 50, 100,    or 200 segments as selected from within the       plug-in Status or Timebase Setup screen. Each     time a trigger occurs, acquisition for the        current segment completes, and acquisition for    the next segment begins. When all segments are    completed, the result is displayed. Selecting     Sequence Mode again before all segments have      been acquired causes the acquisition to halt      and those segments which have been acquired to    be displayed. If Sequence Mode is selected a      third time, acquisition is enabled again,         overwriting all previous segments.                  Sequence Trigger Types are selectable in the    Acquisition Setup screen. This may be accessed    either from the Configure System screen or by     pressing the `MMODIFY`N key and then a            `MTRIGGER MODE`N key. The Sequence Trigger        Type options are Single and Normal. Single        Sequence acquires the requested number of         segments and displays the sequence waveform.      To arm the circuit again for another sweep,       press `MTRIGGER MODE`N again to re-select         Sequence. Normal Sequence will keep acquiring     and displaying sequence waveforms until the       `MTRIGGER MODE`N key is pressed again to          re-select Sequence.                           Grids                                                   If all eight traces have different vertical     magnitudes, displaying them on different grids    simplifies trace interpretation. Placing them     on a common grid helps trace comparison.            Each time the `MGRIDS`N key is pressed a        different grid size appears. For full screen      displays, the choices are Single, Dual, Quad,     and Octal grids. For half screen displays,        such as when a setup screen or waveform           parameters are displayed, the choices are         Single, Dual, and Quad grids. The 7200            automatically maps the traces to the grids,       placing the lowest numbered trace which is        displayed on the upper most grid, the next        trace on the next grid, etc. Although traces      are initially allocated to grids, they can be     moved into other grids for comparisons by         using the `MVertical Position`N knob.         Display Options                                         To access the Display Options Setup screen,     press `MMODIFY`N and then `MGRIDS.`N The          fields of the Display Setup screen are:         Axis Labels                                           When this field is set to ON and the grid is    single or dual, the 7200 prints the value of      the end points for the active trace on both       the horizontal and vertical axes.               Histogram Orientation                                 Specifies how histograms will be displayed      by the 7200. The selections are STANDARD and      INVERT. In the standard orientation, the          histogram is drawn with the zero baseline at      one division up from the bottom of the grid       and the peaks grow upward. When INVERT is         selected, the baseline is drawn one division      down from the top of the screen and the peaks     grow downward.                                  Return                                                Pressing the Return key will save all the       changes in non-volatile memory and exit the       menu                                            Cancel Changes                                        Pressing the Cancel Changes key cancels all     modifications. It exits the menu and restores     the original setup.                           Vertical Position                                       This continuous knob moves the Selected         trace vertically anywhere on the screen,          allowing you to separate or overlay the           traces. (The Selected trace is indicated by a     rectangle around its trace label. If a trace      is not Selected, pressing its `MTRACE`N key       makes it the Selected trace.) This control        does not affect the vertical offset of the        acquisition channel.                          Vertical Expand                                         This detented knob vertically expands the       Selected trace around the center of its home      grid. (The Selected trace is indicated by a       rectangle around its trace label. If a trace      is not Selected, pressing its `MTRACE`N key       makes it the Selected trace.) The vertical        scale factor indication under the trace label     is automatically adjusted. The expansion does     not affect the amplifier settings of the          acquisition channel.                                The trace can be expanded or contracted         vertically in steps that are multiples of one,    two, and five.                                Vertical Reset                                          If the Selected trace is vertically expanded    or off the center of the grid, pressing the       `MVERTICAL RESET`N key unexpands the trace and    positions it on the vertical center of the        grid. Pressing the key again returns the trace    to its previous expansion and position.       Horizontal Position                                     This continuous knob moves the Selected         trace horizontally anywhere on the screen,        allowing you to align traces in time. (The        Selected trace is indicated by a rectangle        around its trace label. If a trace is not         Selected, pressing its `MTRACE`N key makes it     the Selected trace.) This control does not        affect the trigger delay of the acquistion        channel.                                            If part of the trace is positioned off the      display grid, the View Finder can help            determine the position of the displayed           section relative to the grid.                       If you are displaying one segment of a trace    acquired with Sequence `MTRIGGER MODE,`N          rotate the `MHORIZONTAL POSITION`N knob to        display other segments. When a segment            boundary is reached, an extra turn of the knob    is required to display the next segment. The      number of the displayed segment is indicated      next to the trace label.                            As discussed below, horizontal position and     expansion actually change the number of points    of the Selected trace.                        Horizontal Expand                                       Use this detented knob to horizontally          expand (i.e. magnify) the Selected trace          around the center of the grid. (The Selected      trace is indicated by a rectangle around its      trace label. If a trace is not Selected,          pressing its `MTRACE`N key makes it the           Selected trace.) As the Selected trace is         expanded, the View Finder shows a shorter         portion of the trace inside the grid box to       indicate that there is data which is currently    not on the screen. The horizontal scale factor    indication under the trace label is               automatically adjusted. The expansion does not    affect the timebase of the acquisition            channel.                                            The trace can be expanded or contracted         horizontally in steps that are multiples of       one, two, and five.                                 Horizontal expansion determines the number      of points of the trace that is displayed. The     horizontal expansion can be used to display as    few as 40 points at a time. For example, with     50k acquired samples, 50 points represents a      magnification of 1000 times. When the number      of data points is less than the number of         display pixels across the screen, linear          interpolation is used to connect the data         points. The actual data points are displayed      with greater intensity than their                 inter-connections in order to distinguish the     actual samples.                                     When displaying a trace acquired with           Sequence `MTRIGGER MODE,`N rotating the           `MHORIZONTAL EXPANSION`N knob clockwise one       click displays the first segment of the trace.    Additional rotations will expand that segment.    Rotating the `MHORIZONTAL POSITION`N knob         moves to the other segments. The number of the    displayed segment is indicated next to the        trace label.                                        Unlike the vertical controls, `MHORIZONTAL      POSITION`N and `MHORIZONTAL EXPANSION`N           actually change the number of points of the       Selected trace. Only the points displayed on      the screen as selected by the horizontal          controls are used for processing in subsequent    trace equations, for storing the trace (to        floppy, a memory, or Record Traces), or for       remote read-out. This means that if trace 2 is    defined to be trace 1 (i.e. T2 = T1),             horizontally expanding and repositioning trace    1 will also horizontally expand and reposition    trace 2 the same amount. Selecting trace 2 and    changing its horizontal expansion and position    (relative to trace 1), will not affect trace      1. When trace 2 is expanded, however, the         corresponding area on trace 1 is highlighted. Horizontal Reset                                        If the Selected trace is horizontally           expanded or off the center of the grid,           pressing the `MHORIZONTAL RESET`N key             unexpands the trace and positions it on the       horizontal center of the grid. Pressing the       key again returns the trace to its previous       expansion and position.                       Common Expand/Multi Zoom                                Press the `MTurn On Multi Zoom`N softkey to     simultaneously expand and reposition the          selected group of traces. The Common Expand       Setup screen lets you select which traces are     in the selected group. You can also select        whether the group applies to the horizontal or    vertical controls or both. The Common Expand      Setup screen is accessed by pressing              `MMODIFY`N followed by `MTurn On/Off Multi        Zoom`N or either of the expand or position        controls.                                           Press the `MTurn Off Multi Zoom`N to            individually expand and reposition each trace.  Common Expand Setup                                   The softkeys and fields on the Common Expand    Setup are:                                      Clear All                                             This softkey removes all of the traces          currently selected in the trace group.          Set All                                               This softkey is a short cut to allow you to     select all of the traces.                       Set On                                                This softkey selects all the traces which       are on to be in the trace group.                Lock                                                  Is used to select whether the Horizontal        and/or Vertical expansion controls are locked     together for the selected group of traces.      T1 ... T8                                             Eight fields which permit you to select any     combination of traces to controlled together.     Every time a trace is added to this group, all    of the traces in the group are automatically      reset to their unexpanded position in order       for all the traces to start at the same           expansion. When any of the traces in this         group is the selected trace and a expansion       control is changed, the control is applied to     all of the traces in the group. Note that a       dotted select box is used to indicate the         other traces in the group. When a trace, which    is not in the group of traces for common          expansion, is selected, changing an expansion     control only affects that trace.              Clear Display                                           When averaging, enveloping, histograms,         trends, or persistence mode is enabled, the       `MClear Display`N key appears on the Main         Screen. Pressing this softkey clears the          accumulated results. Accumulation of data         restarts with the next acquisition.           Persistence Display                                     Typically, each sweep of displayed traces is    erased before the next sweep is displayed.        Persistence mode keeps prior sweeps on the        display to allow comparison of successive         acquisitions. The number of sweeps remembered     in the persistence display is set from the        Persistence Setup screen which is accessed by     pressing `MMODIFY`N and then the `MTURN ON        PERSISTENCE`N key. The number of sweeps may be    set in a 2, 5, 10, 20, ..., 200, INFINITE,        AUTO_STOP sequence. The AUTO_STOP setting is      infinite persistence with automatic stop of       acquisition when any bin in the persistence       array reaches full scale. The current setting     for the number of sweeps will be displayed        under the grid along with the number of sweeps    currently contained in the persistence array.     Note that if XY mode is active, only INFINITE     persistence is possible.                            The persistence display is cleared whenever     a control, mainframe or plugin, which affects     the display is changed or when the `MClear        Display`N key is pressed.                           The vertical and horizontal cursors are         available on the persistence display grid, and    can be used to make absolute and relative         voltage and time measurements.                XY Display Mode                                         The X versus Y (XY) display mode allows you     to display one trace against another. The         technique is normally used to compare the         amplitude information of two waveforms and can    reveal phase and frequency information through    the analysis of patterns called Lissajous         figures. When XY display is enabled, a square     grid, in the top half of the screen is used       for the XY display while the rectangular grid     underneath simultaneously shows the original      source waveforms. The rectangular grid can be     either a single or dual grid and may be           selected by the GRIDS key. To select the two      waveforms for display in the XY mode, simply      use the TRACE ON/OFF keys. If both traces are     off, the first trace selected is automatically    assigned to the X (horizontal) axis of the XY     display. The second trace selected is assigned    to the Y (vertical) axis. Both selections are     indicated to the left of the square grid.         Selecting another trace key assigns the newly     selected trace to the Y axis and turns off the    previous Y trace.                                   For the XY display to be correctly              generated, the traces selected must be of the     same time or frequency interval/point and have    the same horizontal unit (seconds or hertz).      As soon as two compatible traces have been        selected, the XY display is automatically         generated. If incompatible traces are             selected. a warning message is displayed at       the top of the screen. If two compatible          traces are selected that have different           trigger points , then the common part of each     trace is highlighted and only that part is        plotted in the XY display.                          If Persistence is on when XY mode is enabled    or if `MTURN ON PERSISTENCE`N is pressed while    the XY display is active, the X vs Y plot is      not cleared after each sweep to allow             comparison of successive acquisitions. In this    mode, the X vs Y display is only cleared when     a control, mainframe or plugin, which affects     the display is changed or when the "Clear         Display" key is pressed.                            As with the standard waveform display, time     and volage cursors can be used with the XY        display. The time cursors are similiar to         those of the standard waveform display, with      additional cursors at the corresponding XY        position in the square XY display. To make a      measurement, press the `MCURSOR MEASUREMENTS`N    key to activate the cursors. The vertical         value of each cursor is shown below the trace     label. The time cursor value, which is common     to both traces, is shown below the grids. In      addition, combinations of the vertical values     are shown to the right of the XY grid. These      measurements are:                                     The ratio of Y/X                                The ratio in dB  (20 * log10(ratio))              The product of Y * X                            The distance to the origin                            r = sqrt(X*X + Y*Y)                       The angle                                             theta = arctan(Y/X)                                                                           where X and Y are defined                       by cursor type as follows:                                                                          vertical relative    Vdif - Vref                  vertical absolute    Vref - 0                     horizontal relative  Vdif - Vref                  horizontal absolute  Vref - 0  or                                             Vref - Voffset                                                        For the horizontal absolute cursor, you can     choose between 2 references. The refernce can     either be at X = 0, Y = 0 or X and Y equal to     their values at the center of the grid square.Program                                                 The `MProgram`N softkey in the main screen      is used to access the automatic control           features of the LeCroy 7200 Precision             Oscilloscope.                                       Programming allows you to store a sequence      of front panel commands in a program. The         program can be stored on the internal disk or     a floppy disk for use later, or can be            executed right away.                            Modifying Program Parameters                          When preceded by the `MModify`N key, the        `MProgram`N softkey brings up the program         setup screen. This is used to set program         parameters, examine programs, and store or        recall programs on disk.                        Actions                                               Next to the `MProgram`N softkey in the main     screen is a description of what will happen       when you press it.                                  The `MLearn`N option is only shown when         there is currently no program. When the           softkey is pressed, succeeding key presses and    knob changes are saved for execution later.       While commands are being collected in this        way, the `MStop Learn`N option is displayed.        The `MRun`N option is displayed when a          program is ready to be executed. When the         softkey is pressed, the option is changed to      `MStop Run,`N and the program is started.           During execution, pressing any key or           turning any knob will suspend the program with    a message asking if you want to abort the         program. At this point you must press either      the `MYes`N or the `MNo`N softkey to indicate     your choice.                                    Program Setup Screen                                  The upper half of the screen shows a portion    of the program. If a program is terminated due    to an error, the line containing the error        will be highlighted the next time you enter       the program setup screen to show you where the    error occurred. A brief message describing the    problem will be displayed at the top of the       screen.                                         Speed                                                 The `MSpeed`N option has three choices:         FAST, MEDIUM, and SLOW. Normally, the FAST        speed is appropriate for running programs. It     executes the program as fast as possible. When    first testing a program, the SLOW speed is        useful. It executes the program one command       per second, and displays the text of each         command as it is executed. With MEDIUM speed,     a small delay is added after each command is      executed. This gives the display a chance to      be updated, so you can see the effect of          individual commands.                            Disk                                                  This control is used to select which disk       the `MRecall File`N and `MStore File`N            controls refer to. Choices are INTERNAL and       FLOPPY. If FLOPPY is selected, the directory      of the floppy disk will be read when the          program setup screen is entered.                Recall File                                           All programs which are found on the selected    disk are available for recall through this        control.                                        Store File                                            Before storing a program on disk, you should    set the name of the `MStore File`N using this     control. When the cursor box is on this field,    the softkey `MEdit Text`N appears. By pressing    this key, you may change, add or delete           characters from the `MStore File`N name.        Clear                                                 This softkey erases the current program. It     causes the displayed program to be erased from    the screen, but has no effect on any copy         which may have been stored on disk.             Prev Page                                             Press this softkey to scroll the program        down in the window. This displays the eight       lines prior to the text currently displayed.    Next Page                                             Press this softkey to scroll the program up     in the window. This displays the eight lines      after the text currently displayed.             Learn Append                                          After collecting a sequence of commands, the    `MLearn`N option is not available with the        `MProgram`N softkey in the main screen. To        allow you to append more commands to the          program, the `MLearn Append`N softkey appears     in the program setup screen. When this softkey    is pressed, key presses and knob changes are      saved at the end of the current program. The      option of the `MProgram`N softkey is changed      to `MStop Learn`N to indicate that a program      is being learned.                               Learn Setup                                           This softkey may be used to learn the           current state of the 7200. It appears whenever    it is permissable to learn a new program using    the `MLearn Program`N softkey in the main         screen or to append to an existing program        using the `MLearn Append`N softkey in the         program setup screen.                               The `MLearn Setup`N softkey causes commands     to be generated at the end of the current         program. When executed, these commands will       reset the 7200 to the state which existed when    the `MLearn Setup`N sofkey was pressed.         Store                                                 Press this softkey to store the current         program on disk. The disk and file name should    be selected first using the `MDisk`N and          `MStore File`N controls.                        Recall                                                Press this softkey to recall a program from     disk. The disk and file name should be            selected first using the `MDisk`N and `MRecall    File`N controls.                                    After the program is recalled, the first few    lines of the program are displayed.                 To make it easier to copy programs between      disks, the `MStore File`N name is set to the      `MRecall File`N name when this softkey is         pressed.                                        Return                                                Press this softkey to leave the program         setup screen and accept the changes you made.   Disk Utilities                                        The disk utilities screen can be entered by     pressing this softkey. It may be used to          examine or delete files on a disk (including      those other than programs).                     Read New Floppy Disk                                  If you change floppy disks while in the         program setup screen, press this softkey to       indicate that the directory should be read        again.                                          Related Remote Commands                               The following commands are available for        control of programs remotely via GPIB or          RS-232:                                          Command Name   Alias       Function               PROG_CLEAR     PRCL   Clears the program          PROG_LIST?     PRLI?  Lists program files         PROG_MODE      PRMO   Select operating mode       PROG_RECALL    PRRC   Recall program from disk    PROG_STORE     PRST   Store program on disk       PROG_SETUP     PRSU   Set options                 PROG_ARG       PRAR   Sets an argument string                           for a chained program.   Making Measurements on Waveforms                        The 7200 can perform waveform parameter,        horizontal, or vertical measurements each time    a trace is updated on the display. Pressing       the `MCursor Measurements`N key turns on the      currently selected measurement type.              Subsequent presses cycles through the possible    measurement types. To stop the measurements,      press the `MTurn Off`N softkey at the lower       left of the screen. Cursor Measurements can be    made while any number of traces are displayed.Moving the cursors                                      The continuous knob, under the center of the    display, is used to move the cursors around on    the screen. The continuous knob is labelled       `MMove`N followed by a picture of the cursor      which you can move. For all cursor types,         except MARKER, there are two cursors, the         Reference and the Difference cursor. The          detented knob under the screen is labelled        `MSelect Cursor`N . Rotating this knob changes    which cursor the continuous knob moves. It        also allows you to move both cursors by           selecting the picture with both cursors drawn.Types of Measurements                                   The types of measurements which can be made     with each cursor type are described below:    Basic Parameters                                        When you choose `MBasic Param`N a set of 14     waveform parameters are calculated for the        selected trace. To display the results, the       grid is automatically reduced to half size.       The parameters are recalculated each time the     trace is updated or the cursor is moved. To       change the selected trace, press the desired      trace key.                                          The section of the trace used in computing      the parameters lies between two cursors. You      can choose to have independent cursors for        each trace or have all the cursors "locked"       together so that they are on the same place on    all the traces, by pressing `MMODIFY`N and        then the `MCURSOR MEASUREMENTS`N key. The         cursors are represented by:                       Cursor       Locked Independent                   -----------------------------------------                                                           Reference       `f2`f0        `f2`f0                                                              Difference      `f2`f0        `f2`f0                                                              both cursors    `f2`f0        `f2`f0                                                                Note that the Reference and Difference          cursors merely delineate a region of the          trace; their relative ordering is irrelevant.                                                       For time domain waveforms, the parameters         computed are:                                                                                       frst - time at first point                        last - last point                                 max - maximum                                     freq - frequency                                  min - minimum                                     per - period                                      pkpk - peak to peak                               wid - width                                       mean - mean                                       dly - delay                                       sdev - standard deviation                         rise - 10-90% rise time                           rms - root mean square                            fall - 90-10% fall time                                                                             For frequency domain waveforms, the parameters    computed are:                                                                                       frst - time at first point last - last point      max - maximum tpwr - total power                  xamn - frequency at min xamx - at max                                                               For histogram waveforms, the parameters           computed are:                                                                                       frst - time at first point last - last point      max - maximum mean - mean                         min - minimum medi - median                       pkpk - peak to peak mode - mode                   sdev - standard deviation totp - population       rms - root mean square                            maxp - maximum value                              fwhm - full width at half max                                                                         For a detailed description of each parameter    refer to the Waveform Parameter Definitions       section below.                                  Parameter Notation                                    A graphic symbol may appear between the         parameter name and its value to indicate          additional information. The symbols and their     meanings are:                                                                                       waveform is partially in overflow                waveform is partially in underflow               waveform is part overflow, part underflow        upper limit shown, actual value may be less      lower limit shown, actual value may be more      value is average over up to 500 periods          computed on integral number of periods           waveform is not a pulse                          parameter calculated on histogram                parameter calculated on fft waveform             parameter does not apply to this waveform        waveform contains undefined points,                   displayed value is suspect              ?     insufficient data to compute parameter     ---  Parameter Averaging                                   When Basic or Extended Parameters are           enabled, the `MAverage Parameters`N softkey       appears. The parameter averaging feature          transforms the parameter display from             instantaneous values to average values. When      parameter averaging is off, the parameter         values displayed are the instantaneous values     for the currently displayed waveform sweep.       When parameter averaging is on, the parameter     values computed for each waveform sweep are       averaged with the parameter values from the       previous sweep with a weight of 1/20. The         displayed values are thus a continuous or         running average of the values of successive       acquisition sweeps.                                 To turn on parameter averaging, press the       `MAverage Parameters`N softkey. Its label will    change to `MStop Average Parameters.`N To turn    off parameter averaging, press the `MStop         Average Parameters`N softkey.                 Extended Parameters                                     With extended parameters, the 7200 will         calculate up to twenty parameters on any          combination of traces. Their values are           displayed under a half screen grid. The           cursors are the same as those used for Basic      Parameters. To choose the parameters and the      traces they are calculated on press `MMODIFY`N    and then the `MCURSOR MEASUREMENTS`N key.       Extended Parameter Setup                              The Extended Parameter Setup Screen contains    selection fields for choosing up to twenty        trace-parameter combinations. Each selection      has two fields separated by a colon (:). The      left field specifies the trace to be measured     and the right field specifies the parameter to    be calculated.                                      The parameter values will be displayed on       the Main Screen (when Cursor Type EXT PARAM is    enabled) in the same locations as selected in     the setup screen.                                   The `MMove Box`N knob is used to select a       field for modification. The options list in       the lower right screen will indicate available    choices with the current selection in the         center. To change the selection, rotate the       `MModify Value`N knob to move the desired         choice to the center of the list. The new         choice will also replace the previous             selection in the box.                               When "--" is selected from the Options List     for either the trace or parameter field, no       parameter will be calculated and the              corresponding location in the Extended            Parameter display on the Main Screen will be      blank.                                              The `MClear All`N softkey deselects all the     traces and parameters and replaces them with      "--".                                               The section of the trace used in computing      the parameters lies between two cursors. The      `MUnlock/Lock Cursors`N key allows you to         choose to have independent cursors for each       trace or have all the cursors "locked"            together so that they are on the same place on    all the traces. As shown in the basic             parameters section above, different cursors       are used to distinguish the two modes.              After selecting traces and parameters, press    the `MReturn`N softkey to save the changes and    display the Main Screen. The `MCancel             Changes`N softkey cancels all changes,            restores the original setup, and displays the     Main Screen.                                  Waveform Parameter Definitions                          The waveform parameters available are           briefly described below. The parameters are       grouped according to the types of waveforms on    which they operate: General (all types of         waveforms), Time Domain, Frequency Domain, and    Histogram parameters. Some parameters have        arguments which may be specified in the           Extended Parameter Setup Screen. These are        described below. More detailed definitions of     the parameters appear in the 7200 Users           Manual.                                         Parameter Calculation for Basic/Extended Display      Parameters displayed in Basic or Extended       Parameters are calculated only on the section     of the trace delineated by the two cursors. If    the trace is a sequence waveform, the             parameters are calculated only on the first       segment between the cursors (i.e., the segment    in which the leftmost cursor is located).       Parameter Calculation for Histogram and Trend         For histograms and trends, parameters may be    calculated on traces, channels, or memories.      (See the Histogram and Trend sections.)           Parameters on traces are calculated only on       the section of the trace delineated by the        parameter cursors. If the trace is a sequence     waveform, the parameters provide a list of        values for all segments between the cursors       (including the segments in which the left and     right cursors are located). Parameters on         channels and memories are calculated on the       entire waveform.                              General Parameters                                    data - data value at left cursor; this                   parameter is useful for histograms,               where it can be used to provide all               of the data values in a waveform           date - date of acquisition of the waveform        dur  - acquisition duration. For a sequence              or history waveform, time from first              trigger to last trigger. For a single             segment of a sequence, time from                  trigger of previous segment to                    trigger of current segment.                frst - horizontal position of first (left)               cursor                                     last - horizontal position of last (right)               cursor                                     pnts - number of points between the cursors       time - time of acquisition of the waveform                                                      Time Domain Parameters                                ampl - amplitude; top minus base                  area - area under waveform between cursors;              sum of sampled values times duration              of a sample                                base - the lower most probable state (for                rectangular waveforms)                     cycl - cycles; the number of pairs of                    transitions in the same direction                 between the cursors                        dly  - delay; time from trigger to midpoint              of first transition                        duty - duty cycle; average duration above                midpoint value as percentage of period     dnl  - differential nonlinearity; maximum                absolute difference between adjacent              specified code levels and the ideal               code level.  The input is assumed to              be a Digital to Analog Converter                  output. The portion of the waveform               to be processed is assumed to be                  displayed between the vertical cursors.           The steps argument is the number of               ideal quantization levels. The                    results is measured in terms of LSB's.     fall - fall time; duration of pulse waveform's           falling transition between two user-              specified thresholds, averaged for                all falling transitions between the               cursors. The thresholds are specified             as a percentage of the amplitude.                 Default values are 90% and 10%.            freq - frequency; reciprocal of period            inl  - integral nonlinearity; maximum                    absolute difference between                       specified code levels and the ideal               code level.  The input is assumed to              be a Digital to Analog Converter                  output. The portion of the waveform               to be processed is assumed to be                  displayed between the vertical cursors.           The steps argument is the number of               ideal quantization levels. The                    results is measured in terms of                   percentage.                                lmax - local maximum; average of all local               maxima between the cursors. The                   hysteresis argument may be used to                discriminate peaks from noise in the              data. It is specified in divisions in t           range 0.01 to 8.0.  The default                   hysteresis is 0.5 divisions.               lmin - local minimum; average of all local               minima between the cursors. The                   hysteresis argument may be used to                discriminate troughs from noise in the            data. It is specified in divisions in t           range 0.01 to 8.0.  The default                   hysteresis is 0.5 divisions.               lnum - number of local peak pairs. The                   hysteresis argument may be used to                discriminate peaks from noise in the              data. It is specified in divisions in t           range 0.01 to 8.0.  The default                   hysteresis is 0.5 divisions.               lpp  - local peak to peak (lmax-lmin); average           for all pairs of local maxima and                 minima between the cursors. The                   hysteresis argument may be used to                discriminate peaks from noise in the              data. It is specified in divisions in t           range 0.01 to 8.0.  The default                   hysteresis is 0.5 divisions.               ltbp - local time between peaks; average for             all features between the cursors. The             hysteresis argument may be used to                discriminate features from noise in the           data. It is specified in divisions in t           range 0.01 to 8.0.  The default                   hysteresis is 0.5 divisions.               ltbt - local time between troughs; average for           all features between the cursors. The             hysteresis argument may be used to                discriminate features from noise in the           data. It is specified in divisions in t           range 0.01 to 8.0.  The default                   hysteresis is 0.5 divisions.               ltmn - local time at minimum; time from                  trigger to first local minimum between            the cursors.  The hysteresis argument             may be used to discriminate troughs               from noise in the data. It is specified           in divisions in the range 0.01 to 8.0.            The default hysteresis is 0.5 divisions    ltmx - local time at maximum; time from                  trigger to first local maximum between            the cursors. The hysteresis argument              may be used to discriminate peaks from            noise in the data. It is specified in             divisions in the range 0.01 to 8.0.  Th           default hysteresis is 0.5 divisions.       ltot - local time over threshold; time over a            user-specified percentage of the local            peak-to-peak range, averaged for all              features between the cursors.  Default            percentage is 50%.  The hysteresis                argument may be used to discriminate              peaks from noise in the data. It is               specified in divisions in the range 0.0           to 8.0.  The default hysteresis is                0.5 divisions.                             ltut - local time under threshold; time under            a user-specified percentage of the                local peak-to-peak range, averaged for            all features between the cursors.                 Default percentage is 50%. The                    hysteresis argument may be used to                discriminate peaks from noise in the              data. It is specified in divisions in t           range 0.01 to 8.0.  The default                   hysteresis is 0.5 divisions.               max  - maximum value of the waveform between             the cursors                                mean - average or DC level of the waveform.              If waveform is periodic, computed over            integral number of periods                 medi - median value of waveform.                         If waveform is periodic, computed over            integral number of periods                 min  - minimum value of the waveform between             the cursors                                mode - mode of waveform.                                 If waveform is periodic, computed over            integral number of periods                 nbph - narrow-band phase in degrees relative             to start of waveform (left parameter              cursor changes the starting point) for            a selectable frequency; an integer                number of cycles is used.                  nbpw - narrow-band power in dBV (relative to             1V rms) for a selectable frequency; an            integer number of cycles is used           ovsn - overshoot negative; base value                    minus minimum sample value,                       as a percentage of amplitude               ovsp - overshoot positive; maximum sample                value minus top value, as a                       percentage of amplitude                    per  - period; time of a full cycle, averaged            for all full cycles between the cursors    pkpk - peak-to-peak; difference between                  maximum and minimum values                 rise - rise time; duration of pulse waveform's           rising transition between two user-               specified thresholds, averaged for                all rising transitions between the                cursors. The thresholds are specified             as a percentage of the amplitude.                 Default values are 10% and 90%.            rms  - root mean square; square-root of sum              of squares divided by number of points.           If waveform is periodic, computed over            integral number of periods                 sdev - standard deviation; square-root of sum            of squares of difference from mean,               divided by (number of points - 1).                If waveform is periodic, computed over            integral number of periods.                tafl - time at fall; time from trigger to                midpoint of first falling transition       tars - time at rise; time from trigger to                midpoint of first rising transition        top  - the higher most probable state             wid  - width of the first pulse (either                  positive or negative), averaged for               all similar pulses between the cursors     xamn - time from trigger to minimum value         xamx - time from trigger to maximum value                                                       Frequency Domain Parameters                           max  - amplitude of the largest frequency                component                                  npwr - noise power; total power minus power              in fundamental minus power in harmonics           Applies only to FFTPWD waveforms.          tpwr - total power; area under the power                 density spectrum. Applies only to                 FFTPWD waveforms.                          xamn - frequency at minimum amplitude             xamx - frequency at maximum amplitude                                                           Histogram Parameters                                  ampl - amplitude; top minus base                  base - centroid of leftmost significant peak      fwhm - full width at half max; the width of              the distribution surrounding the mode             including values which are at least               1/2 of the maximum bin population          fwxx - full width at user-specified percentage           of the maximum bin population.                    Default percentage is 50%.                 max  - horizontal coordinate of rightmost                non-zero bin                               maxp - maximum population in any bin (vertical           value at the mode)                         mean - horizontal centroid of the distribution    medi - horizontal median (horizontal value of            midpoint of distribution)                  min  - horizontal coordinate of leftmost                 non-zero bin                               mode - horizontal coordinate of bin with                 maximum population                         pctl - percentile; horizontal coordinate                 to the left of which lies a user-                 specified percentage of the                       distribution.                                     Default percentage is 95%.                 pkpk - peak-to-peak; horizontal difference               between maximum and minimum values         pks  - number of peaks in the histogram           rms  - histogram root mean square; square-               root of sum of squares divided by                 number of values, computed on the                 distribution                               sdev - histogram standard deviation; square-             root of sum of squares of difference              from mean, divided by                             (number of values - 1), computed on               the distribution                           top  - centroid of rightmost significant peak     totp - total population in the histogram          xapk - Horizontal mean of the user-specified             peak. Peak is specified by number,                where largest area peak is number 1,              next largest is number 2, etc.                    Default peak number is 1.                                                                  Vertical Cursors                                      These cursors measure the vertical distance     between two horizontal lines on one grid. The     difference, in the trace's units is indicated     under the trace labels for all traces on the      same grid. For traces not on the same grid,       the trace's units per division, for both the      vertical and horizontal dimensions are shown.     The vertical cursors are represented by:                                                            Reference `f2`f0                                                                                   Difference `f2`f0                                                                                  both cursors `f2`f0                                                                                  NOTE: If the Reference cursor is above the      Difference cursor, the resulting value is         indicated as a negative value.                  Marker                                                The MARKER cursor  measures the absolute       vertical and horizontal position of a point on    a trace. All traces with the same horizontal      units are measured simultaneously. A marker       cursor is located at the same horizontal          position on each trace. Cursors appearing on      each trace are simultaneously moved by            rotating the continuous knob under the            display. If traces with different horizontal      units are displayed, moving the cursor past       the end of trace its on, will cause it to go      to the trace with different horizontal units.     If all traces on the screen have the same         units, when the cursor is moved to the edge of    the screen it remains there.                        The vertical measurement reflects the actual    amplitude of the trace at the marker. The         amplitude is indicated under the trace            label(s) for the trace(s) being measured. The     marker's horizontal position is expressed as      the time (or frequency of the trace) between      the trigger and the marker. It is indicated in    the Time or Frequency Field and has the same      units (in time or frequency) as the trace(s)      being measured.                                 Horizontal Cursors                                    The horizontal cursors display the              horizontal distance between the two cursors       and its reciprocal below the grid. The            difference between the vertical values at each    cursor is shown under the trace label for each    trace which have both arrows. All traces with     the same horizontal units are be measured         simultaneously. Each horizontal cursor is         located at the same horizontal position on        every trace. The selected cursor on each trace    is simultaneously moved by rotating the           continuous knob under the display. You can use    the `MSelect Cursor`N detented knob to change     which cursor can be moved. If traces with         different horizontal units are displayed,         moving the cursor past the end of trace its       on, will cause it to go to the next trace with    different horizontal units. If all traces on      the screen have the same units, when the          cursor is moved to the edge of the screen it      remains there.                                    The horizontal cursors are represented by:                                                              Reference    `f2`f0                                                                                Difference   `f2`f0                                                                                both cursors `f2`f0                                                                             NOTE: If the Reference cursor is to the         right of the Difference cursor, the resulting     value is indicated as a negative value.       Waveform Storage                                        The 7200 has several options for storing        trace waveforms:                                    Any waveform display with its annotation can    be preserved on hard copy with a printer or       color plotter. Alternately, a tabular printout    of the waveform data points and acquisition       information can be produced.                        Trace waveforms can be stored on MSDOS          formatted 3.5" floppy diskettes. These            diskettes can be read by any MSDOS compatible     machine. Conversely, waveform data previously     stored on a diskette can be recalled,             displayed, and processed.                           The 7200 has 8 internal non-volatile            memories, M1...M8, available for individual       waveform storage.                                   In Record Traces mode, all displayed traces     are automatically recorded in an internal 4       Mbyte non-volatile circular buffer each time      they are updated with a new acquisition. The      recorded traces may subsequently be replayed,     examined, processed, or stored to floppy          diskette.                                       Clearing Memories and Record Traces Buffer            The 8 internal memories M1...M8 and the         Record Traces buffer are non-volatile, i.e.,      they maintain their contents when the power is    off. They may be cleared by pressing the          `MClear Memories`N softkey in the System          Configure Screen.                             Store                                                   To store trace waveforms to MSDOS compatible    floppy diskettes or to the non-volatile           internal memories M1...M8, press the `MSTORE`N    key. The particular storage operation which       will occur is that which has been previously      selected in the Waveform Storage Setup,           accessed by pressing the `MMODIFY`N key and       then the `MSTORE`N key.                             NOTE: Only those traces which have been         selected in the Waveform Storage Setup and        which are displayed when the `MSTORE`N key is     pressed will be stored.                         Waveform Storage Setup                                To specify the traces to be stored and their    destinations, press `MMODIFY`N and then           `MSTORE`N .                                         Traces may be stored to files on floppy         diskette or to non-volatile internal memories     M1...M8.                                            In the Waveform Storage Setup screen, a         rectangular box is displayed around the           selected field. To move the box, rotate the       `MMove Box`N detented knob. The options list      in the lower right presents the available         choices for the selected field, with the          current value indicated. To change the current    value, rotate the `MModify Value`N continuous     knob. Press the `MReturn`N softkey to save all    changes and return to the Main Screen. Press      the `MCancel Changes`N softkey to restore the     original setup and return to the Main Screen.       The Waveform Storage Setup fields follow:     Disk Drive                                            This read-only field indicates that traces      can be stored to the floppy diskette but not      the internal disk.                              Filename Extension                                    Selects the numeric extensions for the          filenames used for storing to floppy.               A filename has two parts which are separated    by a period. For storing traces, the first        part of the filename corresponds to the trace     label. The trace label is selected in the         Trace Setup screen. The default labels are        Trace1, Trace2, etc.                                The second part of the filename is called       the extension. Traces are always stored to        files with numeric extensions which range from    .000 through .999.                                  Use the Filename Extension field to choose      the numeric extensions of the filenames to        which the selected traces will be stored.       Filename Autoincrement                                Selects whether repeated presses of the         `MSTORE`N key will write the data into            different files or will overwrite the same        file.                                               If Filename Autoincrement is OFF, repeated      presses of the `MSTORE`N key will write the       trace to the same filename. Thus only the         latest data will be saved.                          If Filename Autoincrement is ON, for each       press of the `MSTORE`N key a new filename is      generated by incrementing the extension of the    previously used file. This feature allows you     to store a series of files without                reconfiguring the Waveform Storage Setup in       between each store operation.                   T1,...T8                                              For each trace, choose ENABLED to enable        storage of that trace, or DISABLED to disable     its storage.                                    To                                                    If you enable storage of a trace, the "To"      field appears and allows you to choose where      to store the trace waveform. The choices are      FILE, M1, M2, M3, M4, M5, M6, M7, M8, T1=M1,      T2=M2, T3=M3, T4=M4, T5=M5, T6=M6, T7=M7,         T8=M8.                                          FILE                                                  Choose FILE to store the trace to a file on     the floppy disk. The filename to be used for      the next store will be displayed to the right     of FILE. The filename is equal to the trace       label with a three digit numeric extension.     M1...M8                                               Choose Mx to store the trace to the             specified internal memory.                      T1=M1...T8=M8                                         Choose Tx=Mx to store the trace to the          specified internal memory and automatically       change the indicated trace equation to Tx=Mx      in order to display the waveform in Mx.       Recall                                                  To recall waveforms from floppy diskette to     the internal memories M1...M8, press the          `MRECALL`N key. The particular recall             operation which will occur is that which has      been previously selected in the Waveform          Recall Setup, accessed by pressing the            `MMODIFY`N key and then the `MRECALL`N key.         Waveforms in the memories can be displayed      and/or processed as traces.                     Waveform Recall Setup                                 To select the waveform files to be recalled     and to assign where they will be placed, press    `MMODIFY`N and then `MRECALL`N .                    Waveforms may be recalled from files on         floppy diskette and placed in internal            memories M1...M8.                                   In the Waveform Recall Setup screen, a          rectangular box is displayed around the           selected field. To move the box, rotate the       `MMove Box`N detented knob. The options list      in the lower right presents the available         choices for the selected field, with the          current value indicated. To change the current    value, rotate the `MModify Value`N continuous     knob. Press the `MReturn`N softkey to save all    changes and return to the Main Screen. Press      the `MCancel Changes`N softkey to restore the     original setup and return to the Main Screen.       The Waveform Recall Setup fields follow:      Disk Drive                                            This read-only field indicates that             waveforms can be recalled from floppy diskette    only.                                           Filename Autoincrement                                When recalling waveforms from files on disk,    you may choose whether repeated presses of the    `MRECALL`N key will read the waveform from        sequential files or not.                            A filename has two parts which are separated    by a period: base.extension. If Filename          Autoincrement is OFF, repeated presses of the     `MRECALL`N key will recall the waveform from      the same filename. If Filename Autoincrement      is ON, the first press of the `MRECALL`N key      will recall the waveform from the chosen          filename; subsequent presses will recall the      waveform from files with the same base but        autoincrementing numeric extensions. This         obviates the necessity of reconfiguring the       Recall Setup between recalls when you wish to     recall a sequence of files.                     M1 or T1=M1, M2 or T2=M2, ... M8 or T8=M8             Specifies whether a waveform will be            recalled to the corresponding memory and          whether or not the corresponding trace            equation will automatically be changed. If Mx     is chosen, the waveform is simply recalled to     memory Mx. If Tx=Mx is chosen, the waveform is    recalled to memory Mx and the trace equation      of Tx is automatically changed to Tx=Mx in        order to display the waveform in Mx.                For each memory, choose ENABLED to enable       recall to that memory, or DISABLED to disable     recall to that memory.                          From File                                             If you enable recall to a memory, the "From     File" filename field appears. The options for     the recall filename are a directory listing of    all filenames on the floppy diskette with         numeric extensions. (Waveforms are always         stored to files with numeric extensions).           The file will not be tested to ensure that      it contains a valid waveform until the            `MRECALL`N key is pressed later to initiate       the actual recall operation.                        If Filename Autoincrement is ON, the first      press of the `MRECALL`N key will recall the       chosen file; subsequent presses of the            `MRECALL`N key will recall files with the same    base but numerically increasing extensions. If    no more files exist with greater extensions,      the same file will be recalled repeatedly.      Read New Floppy Disk                                  If you want to recall a file from a             different floppy disk, change the disk and        then press the `MRead New Floppy Disk`N           softkey. The new floppy's files will then be      displayed in the options list.                Disk Utilities                                          The Disk Utilities screen allows you to         format floppy diskettes and access and            maintain files on the internal disk or floppy     diskettes. To access the Disk Utilities           screen, press the `MDisk Utilities`N softkey      in the Waveform Recall Setup, Waveform Storage    Setup, Panel Settings, or Program Setup           screens.                                        Disk Utilites Files                                   The Disk Utilities fields specify the           file(s) to be operated upon.                        In the Disk Utilities screen, use the `MMove    Box`N detented knob to select a field for         modification, and the `MModify Value`N            continuous knob to change the value of the        selected field.                                     The fields follow:                            Disk Drive                                            Choose either FLOPPY or INTERNAL.             Directory                                             Specify the directory (group of related         files) for disk utility operations on the         internal disk drive by choosing either PANEL      SETUPS or PROGRAM.                              Filename                                              Select either ALL FILES or the individual       file for disk utility operations by using the     `MModify Value`N continuous knob to scroll        through the list of all files on the specified    disk and directory.                                 The time and date of the selected file is       displayed to the right of the filename.             If you want to select a file on a different     floppy disk, change the disk and then press       the `MRead New Floppy Disk`N softkey. The 7200    will then read the directory listing of all       files on the new floppy disk.                   Overwrite Existing Files on Copy                      For a copy ALL FILES operation, the             `MOverwrite Existing Files on Copy`N field        specifies whether existing files should be        overwritten, not overwritten, or whether the      user should be asked for confirmation. Choose     either YES, NO, or CONFIRM.                     Disk Utilities Operations                             To perform an operation on the specified        file(s), press the appropriate Disk Utilities     softkey:                                        Copy Internal to Floppy                               When the selected Disk Drive is INTERNAL,       the Copy File softkey is labeled `MCopy           Internal to Floppy.`N Press this softkey to       copy the selected file(s) from the internal       disk to a floppy disk.                              If ALL FILES is selected for the Filename,      all files on the selected directory on the        internal disk will be copied to the floppy. If    one of the files to be copied has the same        name as a file already existing on the floppy     disk, the 7200 will either overwrite the          existing file, not overwrite the existing         file, or ask for confirmation, as specified by    the `MOverwrite Existing Files on Copy`N          field.                                              If an individual file is selected for the       Filename, only the selected file will be          copied from the internal disk to the floppy.      If a file with the same name already exists on    the floppy disk, you will be asked whether you    want to overwrite the file and prompted to        press either the `MYes`N or `MNo`N softkey.     Copy Floppy to Internal                               When the selected Disk Drive is FLOPPY, the     Copy File softkey is labeled `MCopy Floppy to     Internal.`N Press this softkey to copy the        selected file(s) from a floppy disk to the        internal disk. Panel settings files with the      extension .PNL will be copied to the PANEL        SETUPS directory on the internal disk. Program    files with the extensions .SRC and .APD will      be copied to the PROGRAM directory on the         internal disk. Files with other extensions        will not be copied.                                 If ALL FILES is selected for the Filename,      all panel settings and program files on the       floppy will be copied to the appropriate          directories on the internal disk. If one of       the files to be copied has the same name as a     file already existing on the internal disk,       the 7200 will either overwrite the existing       file, not overwrite the existing file, or ask     for confirmation, as specified by the             `MOverwrite Existing Files on Copy`N field.         If an individual file is selected for the       Filename, only the selected file will be          copied from the floppy disk to the internal       disk. If the file is not a panel settings or      program file, a warning message will be           displayed and the copy will be aborted. If a      file with the same name already exists on the     internal disk, you will be asked whether you      want to overwrite the file and prompted to        press either the `MYes`N or `MNo`N softkey.     Delete File                                           Press the `MDelete File`N softkey to delete     the specified file(s). If ALL FILES is            selected for the Filename, all files on the       selected disk and directory will be deleted.      Otherwise, only the individual selected file      will be deleted. You will be asked "Are you       sure?" and prompted to press either the           `MYes`N or `MNo`N softkey before the file(s)      is actually deleted.                            Format Floppy Disk                                    Press the `MFormat Floppy Disk`N softkey to     format a floppy disk. All existing data on the    disk will be lost. You will be asked "Are you     sure?" and prompted to press either the           `MYes`N or `MNo`N softkey before the floppy is    formatted.                                    Hardcopy Setup                                          The `MHardcopy`N key allows you to obtain a     copy of the 7200's screen on a printer,           plotter or floppy disk. Generating the copy       does not affect the operation of the LeCroy       7200 Precision Oscilloscope. The hardcopy can     be aborted at anytime during the plot by          pressing the `MHARDCOPY`N button again.             The Hardcopy Setup lets you change different    parameters of the Hardcopy. To configure these    features, press `MMODIFY`N and then               `MHARDCOPY.`N You will then be allowed to         change the following parameters:                Port                                                  Specifies which port (GPIB, RS232,              Centronics, or Floppy) is used as the output      of the hardcopy. If the Hardcopy `MPORT`N is      the same as the `MRemote Control from`N field     in the Communication Setup screen, then the       local Hardcopy key is disabled and pressing it    sets the User Request bit (URQ) in the            Standard Event Status register (*ESR). This is    to prevent the hardcopy data from disrupting a    Remote Host controller. If you have no Remote     Host controller, simply enter the                 Communications Setup screen via the Configure     System softkey and change the `MRemote Control    from`N field to a value that does not conflict    with the Hardcopy `MPORT.`N If you have a         Remote Host controller, then it can initiate a    remote hardcopy when it is ready.               Filename                                              When Floppy is selected, the Filename field     will appear. To edit the filename, move the       box onto the Filename field and press the         `MEdit Text`N softkey. The `MInsert               Character`N and `MDelete Character`N softkeys     will then allow you to edit the filename a        character at a time.                            Device                                                Specifies the name of the hardcopy device       (printers and plotters). All of the fields        (except Port) are device specific, allowing       you to set different parameters for different     devices and not lose these settings when          switching among different devices.              Annotation                                            Selects whether the 7200 will print/plot the    user comment, logo, softkey labels, and           acquisition parameters (time and date,            timebase, and vertical amplifier settings)        with the grid and waveform.                     Page Feed                                             Applies to printers only and causes a Form      Feed to follow the printed plot in order to       eject the page.                                 Plot Area                                             Displays the Page Size or the Paper Size in     length x width mm. This field automatically      updates as the paper size changes to tell you     the size of the resulting plot/print.           Comment                                               The Comment is a 40 character field which       appears at the top of the plot/print if           Annotation is ON. You edit this field by          pressing the Edit Text softkey which puts the     box around a character in the comment. The        Move Box knob moves the box to the next or        previous character and the Modify Value           continuous knob changes the value in the box      to any letter you select. Pressing the Return     softkey will save the comment.                  Number of Pens                                        For plotters,enables color plots if multiple    pens are present. The 7200 can control up to 8    pens.                                           Pen Speed                                             For plotters, selects the plotter's drawing     rate.                                           Paper Size                                            For plotters, selects the size of the           resulting plot. You should decide how large a     plot you want, select it, then make sure the      plotter has paper in it which is at least as      big as the resulting plot or you will get out     of limit errors which could ruin your plot.       The 7200 supports three standard sizes and one    non-standard size:                                       PAPER SIZE        X ORIGIN   Y ORIGIN          ----------------     --------   --------          A5 = 5.5" x 8.5"       10 mm      10 mm           A4 = 8.5" x 11"         0 mm       2 mm           A3 = 11"  x 17"        10 mm      10 mm           NON STD                                     Size of Grid Square (mm)                              When Non-Standard plot/print is selected,       you may select the size of the grid square        from 0.0 to 99.9 mm. When there is a single       grid, the grid square is the length or width      of one box of the grid in millimeters. The        size of the grid square will determine the        size of the resulting plot/print.               X Position (mm)                                       Selects the left-most position of the plot.     Values range from -999.9 mm to 999.9 mm. Be       careful not to position the plot off the page     or out of the limits of the plotter.            Y Position (mm)                                       Selects the bottom-most position of the         plot. Values range from -999.9 mm to 999.9 mm.    Be careful not to position the plot off the       page or out of the limits of the plotter.       Type of Output                                        For printers, selects the type of output        when the Hardcopy key is pressed. The choices     are Screen Dump, Waveform, and Program. Screen    Dump is similar to plotters except for            printers. Selecting Waveform will print           waveform data in a formatted table. Selecting     Program will print the Program displayed in       the "Program Setup" screen.                     Graphics Density                                      For printers, specifies the resolution. The     higher the resolution, the finer the prints       but also it also takes longer to generate the     prints.                                         Page Size                                             For printers, specifies the size of the         resulting printed plot. The choices are:              A5 = 5.5" x 8.5",  left-justified                 NON STD                                         The size you select for output should match     the size of the paper in your printer or          "out-of-limits" errors could ruin your printed    plot. If NON STD is selected, you will be         asked to select the size of a Grid Square in      millimeters. You may adjust this from 0 to        99.9 mm and this will determine the size of       the resulting printed plot. Be careful not to     exceed the bounds of your printer or the paper    or the printed plot could be ruined.            Trace to Print                                        For printers, when the Type of Output is        Waveform, you must select which trace you want    printed. Channels may be printed by having the    trace made equal to the channel (ie., T1 =        A1).                                            Waveform Block                                        For printers, when the Type of Output is        Waveform, you must specify which part of the      waveform you want printed. Valid choices are:     WAVEFORM BLOCK     DESCRIPTION                    --------------  ----------------------------          DESCRIPTOR: acquisition settings printed                TEXT: user text printed                           TIME: time array(s) printed                      DATA1: Wave Array 1 printed                       DATA2: Wave Array 2 printed                         ALL: All above printed                   If for some reason there is no data in a        waveform block, there will be no printer          output.                                         Return                                                Pressing the Return key will save all the       changes in non-volatile memory and exit the       menu                                            Cancel Changes                                        Pressing the Cancel Changes key cancels all     modifications. It exits the menu and restores     the original setup.                           Configure System                                        When this key is pressed, the 7200 displays     a summary of the trace equations and of the       contents of the memories. The software            revision is also displayed. The Configure         System screen also provides access via            softkeys to screens where you can store and       recall panel settings, select screen              intensity, set the time and date, select the      communication setup (I/O ports), plug-in          configuration, examine the system error log,      select default settings or reset the system.      Each of the softkeys are described in detail      below.                                        Screen Intensity                                        After pressing this softkey a half screen       grid is shown with any traces which are on.       The intensity for "text & traces" and the         "grid" may be set independently. They are set     as a percentage of full scale from 0 to 100.  Set Time and Date                                       This key invokes the Time and Date Setup        screen which displays the current system time     while allowing you to reprogram the clock. The    clock, which is used for time stamping            acquisitions, disk files, etc, is battery         backed up and need only be set once. Use          `MModify Field`N to select hour, minute, day,     date, month, or year and `MModify Value`N to      change it to the appropriate value. When the      highlighted time is the time that you want,       press `MSet New Time & Date`N to set the          clock.                                        Communication Setup                                     This key invokes the Communications Menu        which is used to set the system's GPIB and        RS-232-C Port parameters. The RS-232-C            parameters which can be set are Baud Rate,        number of Stop Bits, Parity, number of Data       Bits, and whether or not to use the Clear to      Send/Request to Send handshake.                 Remote Control                                        Selects the port used to remotely control       the 7200. Only the GPIB and RS-232-C ports may    be used for remote control. If GPIB is            selected for Remote Control, the GPIB address     field will appear.                                                                              `M    Warning: Selecting the same port for both`N `M             Remote Control and Hardcopy will`N `M             disable Remote Control and only`N  `M             allow Hardcopy from that port.`N                                                       GPIB Address                                          If GPIB is selected as the Remote Control       port, this field appears to allow you to          change the GPIB address of the 7200. Valid        GPIB addresses range from 0 to 30 with 0          usually reserved for the Controller.            Baud Rate                                             Specifies the baud rate for the RS-232-C        port. All standard baud rates from 110 through    19200 are supported.                            Stop Bits                                             Specifies whether one or two stop bits are      to be added to each character transmitted and     expected with each character received by the      RS-232-C port.                                  Parity                                                Selects whether the RS-232-C port will use      EVEN, ODD or no parity (NONE).                  Data Bits                                             Sets the number of data bits to be              transmitted and received for each character.    Handshake                                             This selects either a software handshake        (XON-XOFF) or hardware handshake (HARDWIRE).  Acquisition Setup                                       The Acquisition Setup screen contains           options specific to performing data               acquisitions. This screen can be accessed         either thru the Configure System screen or by     pressing the `MMODIFY`N key and then a            `MTRIGGER MODE`N key. The Sequence Trigger        Types are Single and Normal. Single Sequence      acquiries the requested number of segments and    displays a Sequence waveform. To arm the          circuit again for another sweep, press            `MTRIGGER MODE`N again to re-select Sequence.     Normal Sequence will keep acquiring and           displaying Sequence waveforms until the           `MTRIGGER MODE`N key is pressed again to          re-select Sequence.                                 The modularity of the 7200 allows different     timebases and triggers for each plug-in. For      some applications, however, using the same        timebase, or trigger, or both is necessary.       The Acquisition Setup screen allows selection     of INDEPENDENT or LOCKED triggers and             timebases. If locked is selected, changing a      control, such as `MTimebase`N on one plug-in      effectively changes it on all plug-ins. If set    to INDEPENDENT, changing a control on a           plug-in, only affects that one.                     When triggers are locked, there is only one     trigger source for all plug-ins. The source       may be selected from any plug-in by selecting     the desired source with the `MTrigger Source`N    key on the desired plugin.                          `MReference Clock`N                               The 7200 allows the user to use it's            internal reference clock or an externally         applied 10 MHz clock. The screen shows whether    this 7200 contains the optional HIGH accuracy     reference clock or the standard one. If           external clock is selected, it must be applied    to the back connector of the instrument.            `MHistory Display Update`N                        This field selects how often the display is     updated while a history function (histograms,     averaging, etc.) is accumulating data. To         increase the throughput, a longer time between    updates should be used.                             `MAuto Calibration`N                              The 7200 allows the user to enable or           disable automatic calibration of the              instrument. At power-up, auto-calibration is      turned ON. Automatic calibration enables          periodic calibration of both input channels       for the current gain, bandwidth, and time-base    settings.                                           The `MCalibrate All Plug-ins`N key ensures      overall vertical, timebase, and trigger           accuracy by calibrating all plug-ins at it's      cuurent setting. Calibration is also performed    when the 7200 is powered, when Timebase or        Vertical Controls are adjusted, and               periodically thereafter.                      System Log                                              The 7200 maintains a log of all system          messages. Pressing the `MSystem Log`N sofkey      displays this log. If there are more messages     in the log than can be displayed, the             continuous knob is labelled `MNext Line`N and     lets you scroll through the entire log. A         softkey, `MErase Log`N clears the system log. Panel Settings                                          `MPanel Settings`N displays a screen which      is used to store and recall front panel           settings to and from either the 7200's            internal disk or MSDOS formatted 3.5" floppy      diskettes. When `MPanel Settings`N is selected    in the Configure System screen, the following     fields and softkeys appear:                     Disk Drive                                            Choose either INTERNAL or FLOPPY disk for       panel settings store and recall operations.     Store Filename                                        To specify the name of the file in which to     store panel settings, move the box onto the       "Store Filename" field. The `MEdit Text`N         softkey will appear in the upper left corner      of the screen. Press it to edit the filename      letter-by-letter using the `MInsert               Character`N and `MDelete Character`N softkeys     which will appear. When you are finished          editing the filename, press the `MReturn`N        softkey to save the changes and regain access     to other fields and softkeys in the Panel         Settings screen. If the changes are not           desired, press the `MCancel Changes`N softkey     to restore the original filename.               Recall Filename                                       Choose the file from which panel settings       will be recalled. The available choices are       all the panel settings files on the selected      disk.                                           Read New Floppy Disk                                  If the selected Disk Drive is FLOPPY and you    wish to recall from a different diskette,         insert the new diskette and press the `MRead      New Floppy Disk`N softkey. The new floppy's       files will be displayed in the options list.    Store Panel Settings                                  Press the `MStore Panel Settings`N softkey      to store the current front panel settings to      the selected disk and filename.                 Recall Panel Settings                                 Press the `MRecall Panel Settings`N softkey     to recall front panel settings from the           selected disk and filename. After the softkey     is pressed, the following warning prompt will     appear in the message area: `MRECALL PANEL        SETTINGS? (PRESS YES OR NO)`N and the `MYES`N     and `MNO`N softkeys will appear. Press the        `MYES`N softkey to recall panel settings or       press the `MNO`N softkey to cancel the recall     operation.                                    Default Settings                                        Pressing this softkey resets all control        settings to their default values and restarts     the 7200.                                     Reset System                                            Pressing this softkey causes the 7200 to        restart. It does NOT affect any of the current    control settings. It can be used to install       software upgrades by first placing the floppy     disks in the drive and then pressing this key.Trace Setup                                             A trace can represent unprocessed acquired      data, or can be the result of processing          acquired data and/or other traces. For the        default setup, each trace represents acquired     data from one channel. For example, Trace 1       represents data from channel A1, Trace 2          represents data from channel A2. In Trace         Setup, channel data can be processed or           combined to define trace data. Also, trace        combinations can define still other traces.       The Trace Setup allows you to use math            equations to combine and process the source       data. Note: While in this screen, the 7200        suspends acquisition and processing of all        other traces to accelerate updating the           displayed trace. To enter the Trace Setup         press the `MMODIFY`N key and then the             `MTRACE`N key for the trace you want to setup.Editing The Trace Equation                              The Trace Setup will display the trace in       the upper part of the screen. The line below      the grid is the trace equation. This equation     indicates the source(s) of data and how it has    been processed. Use the `MMove Box`N detented     knob to modify different parts of the             equation.                                           The source data for the trace can come from     an acquisition channel or from another trace.     The 7200 automatically determines which           channels or traces can be used as sources and     displays them in the options list. An equation    may contain at most three sources. Since          sources are always associated with a              processing function, they are added or deleted    with processing functions as needed.            Add Processing Functions                              The 7200 performs unary waveform                mathematical operations, which require only       one source, and binary waveform functions         which require two sources. An equation may        contain at most two processing functions. Each    trace can contain one history function            (continuous averaging, summation averaging,       FFT, or extrema).                                   To add a mathematical operation to a trace      equation, move the box to the desired source.     Then press the `MAdd Function`N softkey. A new    math symbol will appear in the equation, and      the box will move onto the symbol.                  If you add a binary waveform function, a        math symbol followed by a second source is        added to the right of the box.                  Delete a Processing Function                          Deleting a processing function is the           reverse of adding a processing function. For      binary waveform processing functions, the         source to the right of the deleted function is    also removed.                                 Unary Waveform Functions                                The Unary waveform functions operate on one     source: trace or data from one channel.           Functions that operate on dual trace              waveforms, such as Extrema, will use only one     of the traces (for Extrema, the Roof data is      used). Waveforms created by using SEQuence        Trigger Mode cannot be processed by some          single waveform functions unless expanded to a    single segment. If processing cannot be           performed, the 7200 displays an error message     at the top of the screen. The unary processing    functions are:                                                                                      1/     inverts the source.                        ABS    the absolute value of the source.          AVGSEQ averages the segments in a sequence               waveform.                                        differentiates the source.                 ERES   applies an enhanced resolution filter             which increases the number of effective           bits while decreasing the bandwidth.             integrates the source.                     EXP    the antilog to the base e of the                  source; that is, e raised to the power            equal to the source. The vertical axis            of the result is dimensionless.            EXP10  like EXP, except the base is 10.           FLOOR  generates a display of the floor                  function of the source; that is, the              minima of the source from all                     acquisitions. If the source is an                 EXTREMA waveform, the lower part is               selected. Otherwise, the EXTREMA is               computed with MAXSWEEPS=100000, and the           lower part is selected.                    LIMIT  generates an EXTREMA waveform for use             in GO-NO-GO testing. See also the                 section "Limit Function".                  LOG    performs a log of a dimensionless                 source to the base e. Values less                 than or equal to zero are set to                  underflow.                                 LOG10  like LOG, except the base is 10.           NEG    negates the values in the source.          ROOF   generates a display of the roof                   function of the source; that is, the              maxima of the source from all                     acquisitions. If the source is an                 EXTREMA waveform, the upper part is               selected. Otherwise, the EXTREMA is               computed with MAXSWEEPS=100000, and the           upper part is selected.                    SIGN   compares the source waveform with zero.           Points which are less than zero are set           to -1.  Points which are equal to zero            are set to zero.  Points which are                greater than zero are set to +1.  The             vertical axis of the result is                    dimensionless.                             SINX   performs 10-to-1 interpolation using a            sin(x)/x filter.                                performs a 1-point moving average.              performs a 3-point moving average.              performs a 5-point moving average.              performs a 7-point moving average.              performs a 9-point moving average.         SQR    squares the source.                              takes the square root of the absolute             value of the source.                                                                     Limit Function                                          The GO-NO-GO test procedure compares its        input waveform with an EXTREMA waveform stored    in M2. The LIMIT function generates such a        waveform by "fattening" its input by an amount    you specify in both the horizontal and            vertical directions.                                  Width                                                 The amount of fattening in the                    horizontal direction, specified                   in divisions.                                 Height                                                The amount of fattening in the                    vertical direction, specified                     in divisions.                                                                           Binary Waveform Functions                               Binary waveform functions operate on two        sources which can be either channels or           traces. The 7200 automatically compensates for    any differences in the vertical gains and         offsets of the two sources. The result's          vertical range is corrected to fit onto the       grid. However, if the source waveforms are        acquired with different plug-ins, both source     waveforms must have timebases with the same       timebase settings and compatible units. The       trigger point of the sources may be different,    but this usually gives results that are           difficult to interpret. Binary waveform           functions cannot be applied to sequence           waveforms unless they are expanded to a single    segment.                                            The 7200 can perform the following              processing on 2 waveforms:                                                                          +     adds a second source to the existing              source.                                     -     subtracts a second source from the                existing source.                            *     multiplies a second source to the                 existing source.                            /     divides the existing source by a second           source.                                                                                   History Functions                                       The history functions use the most recent       waveforms and one or more previously acquired     sets of data to make up a trace. For example,     the averaging functions sum sucessive             acquisitions together. Since this data must be    kept from sweep to sweep only one history         function is allowed per trace. Also, when a       history function is selected, no other            function can be selected at the same time.          When a history function is defined, the         `MClear Display`N softkey appears in the Main     Screen . Pressing it sets all the data back to    zero. In addition, changing any of the plug-in    acquisition parameters, (such as timebase), or    any of the the parameters defining the            operation of the history function (such as Max    Points), resets the history data.                   In general, the history functions require       additional fields to define their operations.     When other fields are necessary, the 7200         automatically displays them below the             equation. The following fields are common to      several history functions:                                                                            Max Sweeps                                            sets the number of sweeps to                      accumulate before pausing.  Unlike                other parameters, changing this                   parameter does not affect the                     history data.                                                                                   Artifact Reject                                       When enabled, any waveform with an                underflow or overflow value is not                included in the computation.  If                  Artifact Reject is turned OFF, any                overflows are set to the maximum                  possible value of the ADC and any                 underflows to the minimum value.                  The waveform is then processed.                                                                 The history functions, and their associated     parameters are described below:                                                                     AVGC  Continuous Averaging can be used to               remove random noise from a signal and             present a better picture of the actual            waveform.  The Continuous average uses            an indefinite number of acquisitions              and enables you to see the effects of             more recent changes to the signal.                When Contiuous averaging is selected,             you can also specify:                                                                               Weight                                                specifies the weighting factors,                  which determine the speed at which                the continuous average follows                    changes in the source waveform. As                the value of the weight decreases,                the average follows changes in the                signal more closely.                                                                      AVGS  Summed Average also improves the signal           to noise ratio and increases the dynamic          range by several bits.  When this                 function is selected, the Max Sweeps and          Artifact Reject parameters may be                 adjusted.                                                                                       When the source of AVGS is an acquisition       channel, the averaging will be performed at a     high rate (dependent on the plugin) if the        following conditions are true:                      1) Record Traces is off.                          2) The acquisition record length is <= 20K      points. (This restriction is specific to the      7242 plugin and may be different for other        plugins.)                                           3) Acquisition type is not RIS or sequence.       4) Each enabled trace which uses a channel      must use a unique channel, and must consist of    either no processing (eg. T1=A1) or an AVGS       function with no decimation (Max # Of Points      >= acquisition record length). For example, if    T1=AVGS(A1) and T2=A2, averaging will be fast.    However, if T1=AVGS(A1) and T2=A1, averaging      will not be fast because the same channel is      used for both an average and display.               When these conditions are met, the `MFAVGS`N    icon will be displayed at the bottom of the       screen.                                                                                             Extrema  The Extrema function generates two             waveforms which represent the minimum             and maximum values of the source (i.e.,           the roof and floor functions displayed            simultaneously).  These waveforms are             generated by repeated comparison of               acquisitions of the source waveform with          the current Extrema waveform.  Whenever           a point of the new waveform exceeds               (either positively or negatively) the             corresponding data point of the                   accumulated Extrema waveform, it                  replaces the former value in the Extrema          waveform.                                                                                     FFT Averages  Fast Fourier Transform Averages           are used to average the result of                 previously computed FFTs.  The following          FFT average functions are available:                                                                  AVGMAG     magnitude                              AVGPWS     power spectrum                         AVGPWD     power density spectrum                                                                 Upon selecting FFT averaging, the Max             Sweeps and Artifact Reject parameters             may be adjusted.                                                                          Fast Fourier Transforms                               FFT   Fast Fourier Transforms provide spectral          analysis of waveforms.  The FFT                   calculation always produces a complex             result and is saved for further                   processing to generate the desired data.          Only one FFT may be defined per trace.                                                              The following single waveform functions           derived from the FFT can be used to               further process the results.                                                                          FFTMAG     magnitude                              FFTPHA     phase                                  FFTPWS     power spectrum                         FFTPWD     power density spectrum                 FFTRE      real part                              FFTIM      imaginary part                         FFTRI      real and imaginary parts                                                               Upon selecting FFT processing, these              parameters can be adjusted:                                                                         Window Type                                           Several windowing functions are                   provided to minimize leakage and                  maximize spectral resolution of                   single shot events.  Choices are:                 Rectangular, Von Han (Hanning),                   Hamming, Blackman-Harris or Flattop.                                                            DC Suppression                                        selects whether or not to remove                  the DC component.                                                                     Histogram and Trend                                     The 7200 can produce continuously updating      histograms of waveform parameter values. Once     the histogram has accumulated the specified       maximum number of values, it maintains only       the most recent values; when a new value is       added to the histogram, the oldest one is         subtracted out. `MHIST`N is reset when the        `MClear Display`N softkey is pressed or its       source waveform acquisition parameters change.    The `MHIST`N function produces a waveform         consisting of one point for each histogram        bin, where the value of each point is equal to    the number of parameter values which fall into    the corresponding bin. Parameter values which     fall outside the histogram limits as specified    by `MCenter`N and `MWidth`N are not included      in any of the histogram bins, but do count as     events for purposes of reaching Max Events.           Max # Of Bins                                         The number of bins in the histogram               which equals the number of points in              the waveform.                                 Parameter                                             The parameter of the source waveform              whose value is to be histogrammed. The            parameter is computed on the section              of the waveform delineated by the                 parameter cursors. If the cursors are             turned off, their last position is                used. Some parameters require 1 or 2              arguments which appear if needed.             Max Events                                            The maximum number of parameter value             events to maintain in the continuous              histogram.                                    Center                                                The midpoint of the central bin of the            histogram. The softkey "Find Center               And Width" can find the center auto-              matically.                                    Width                                                 The Width is 1/10 of the total width              of the histogram. The histogram is                displayed with the horizontal scale               per division equal to the selected                Width/div. The softkey "Find Center               And Width" can be used to find the                width automatically. The Width is                 split into mantissa and exponent                  which can be set independently or                 the mantissa can be set alone and the             exponent will follow its changes.             Vertical                                              The Vertical field allows you to                  change the vertical scaling of the                displayed histogram. Choices are:                                                                       LIN                                                   The vertical axis is linear                       and the histogram will grow                       towards the top.                              MAX                                                   The maximum value of the                          histogram is always at the                        top of the screen.                            LOG                                                   A logarithmic display of                          the histogram is shown.               Events Per Waveform                                   This field is present for parameters              whose source waveform sweep can                   contain multiple events, each of which            generates a parameter value. Choices:                                                               FIRST                                                 The parameter value for the first                 event in the waveform sweep                       contributes to the histogram.                 ALL                                                   The parameter value for all                       events in the waveform sweep                      individually contribute to the                    histogram.                                    AVERAGE                                               The parameter value for all                       events in the waveform sweep are                  averaged together to produce a                    single value.                             Parameter Arguments                                   These fields only appear if the                   selected parameter requires                       arguments.                                    Center On Max Softkey                                 Moves the histogram Center to the mode            of the current histogram and keeps the            Width the same.                               Find Center And Width Softkey                         Automatically chooses the histogram               Center and Width to encompass the Max             Events most recent accumulated events.  Trend                                                 The 7200 can produce rolling trends of the      most recent waveform parameter values.            `MTREND`N is reset when the `MClear Display`N     key is pressed or its source waveform             acquisition parameters change.The `MTREND`N       function produces a waveform consisting of one    point for each parameter value trended, where     the value of each point is equal to the value     of the parameter. `MTREND`N waveforms always      roll from right to left across the screen.            Max # Of Points                                       The maximum number of parameter values            to maintain in the rolling trend which            equals the maximum number of points in            the trend waveform.                           Parameter                                             The parameter of the source waveform              whose value is to be trended. The                 parameter is computed on the section              of the waveform delineated by the                 parameter cursors. If the cursors are             turned off, their last position is                used. Some parameters require 1 or 2              arguments which appear if needed.             Center                                                The center of the range of parameter              values to be included in the trend.               The softkey "Find Center and Height"              can be used to automatically set the              center.                                       Height                                                The Height is 1/8 of the total range              of parameter values to be included in             the trend. The trend is vertically                scaled for display so each division               equals Height/div. The "Find Center               and Height" softkey automatically                 sets the Height.                              Horizontal                                            This allows you to set the horizontal             time interval. If EVENTS is selected,             then whenever an event is received,               it will be accumulated in the trend.          Events Per Waveform                                   This field is present for parameters              whose source waveform sweep can                   contain multiple events, each of which            generates a parameter value. Choices:                                                               FIRST                                                 The parameter value for the first                 event in the waveform sweep                       contributes to the trend.                     ALL                                                   The parameter value for all                       events in the waveform sweep                      individually contribute to the                    trend.                                        AVERAGE                                               The parameter value for all                       events in the waveform sweep are                  averaged together to produce a                    single value used in the trend.           Parameter Arguments                                   These fields only appear if the                   selected parameter requires                       arguments.                                    Find Center And Height Softkey                        Automatically chooses the trend                   Center and Height to best display the             trend of the Max # Of Points most                 recent events.                        Time Of Flight Functions                                Several functions are provided to assist in     analyzing time of flight data. The `MTOFAN`N      function is used to convert an analog time of     flight waveform into a histogram. `MTOFPC`N is    a history function which locates and counts       pulses in a waveform and builds a time of         flight histogram from them. The `MWINHIST`N       function is used to collect data from specific    regions in a time of flight histogram.              The purpose of the `MTOFAN`N and `MTOFPC`N      functions is to generate a histogram in which     the vertical axis is proportional to the          number of ions arriving at the detector. The      horizontal axis can be the arrival time or may    be converted to the ion mass in atomic mass       units (AMUs).                                       The input waveform of `MTOFAN`N is assumed      to be an analog representation of the number      of ions as a function of time. The function       converts this directly to a histogram by          changing the vertical axis from its original      units (typically Volts) to histogram events.      For this reason, it is usually necessary to       apply a large multiplicative constant to the      source. An additive constant may be used to       provide a lower cutoff for the data. If           averaging is required to reduce noise, it         should be applied to the source of the            `MTOFAN`N function using one of the averaging     functions.                                          The input of `MTOFPC`N is a waveform            containing pulses. Each pulse represents the      arrival of one ion at the detector. `MTOFPC`N     updates its histogram by adding one at the        appropriate location for each pulse in the        input. Since it is a history function, the        `MClear Display`N key may be used to restart      the acquisition. Changing any of the              parameters except `MGain, Offset,`N or `MMax      Events`N will also reset this function.             The parameters of `MTOFAN`N and `MTOFPC`N       are listed below. Most parameters are shared      between these two functions. However, the         `MCoupling, Threshold,`N and `MMax Events`N       are only used by the `MTOFPC`N function.              Slope                                                 This control is used to select the                polarity of the input waveform.                   Choices are:                                                                                        POS                                                   The waveform is positive.  For                    TOFPC, the time of each event is                  determined by the positive                        crossing through the threshold.               NEG                                                   The waveform is negative.  For                    TOFPC, the time of each event is                  determined by the negative                        crossing through the threshold.           Coupling                                              This control, used by TOFPC, is                   similar to the COUPLING control in the            plugin's vertical section.  Choices:                                                                AC                                                    The threshold is relative to the                  average value of the waveform.                DC                                                    The threshold is an absolute value        Threshold                                             This control, used by TOFPC, specifies            the vertical value of the input which             is used to determine the time of a                pulse.                                        Gain and Offset                                       The gain and offset are used together             to convert the horizontal offset of a             TOFAN or TOFPC waveform from time to              mass.  The conversion formula is:                                                                   SQRT(Mass) = Gain * (Time + Offset)                                                                 If the Gain parameter is set to zero,             the horizontal axis is not converted              to mass.  Instead, it is the original             time axis of the input.                                                                             Two RCL programs, MASSCAL1 and                    MASSCAL2, have been provided to assist            in setting these parameters.                  Max Events                                            This parameter is used by TOFPC to                determine how many pulses should be               acquired in the waveform before                   terminating acquisition.                                                                      The `MWINHIST`N function is used to extract     data from a histogram generated by `MTOFAN`N      or `MTOFPC.`N It examines windows in the input    having equal size and spacing along the           horizontal axis. This is useful for               applications where the ions of interest have a    regular spacing, as in `MDNA Sequencing.`N          The output of the `MWINHIST`N function is       actually a table presented in the form of a       histogram. The bins along the horizontal axis     are numbered 0, 1, 2, etc. The vertical value     in each bin is the sum of the counts found in     the corresponding window in the input             histogram.                                            Max # Of Bins                                         This specifies the actual number of               bins generated by the WINHIST                     function.  If the value selected is               not a 1-2-5 number, the histogram is              filled on the right with zeros to the             next higher such number.                      Center                                                The center is the location of the                 leftmost window of the input to                   examine.  It is expressed in the                  horizontal units of the input.                Width                                                 This specifies the width of each                  window.  It is expressed in the                   horizontal units of the input.                Spacing                                               The spacing gives the distance from               the center of one window to the center            of the next.  It is expressed in the              horizontal units of the input.                                                            Number of Points to Process                           Waveform processing might require               appreciable execution time. To reduce this        time, you can reduce the number of points to      process for a trace by changing the `MMax # Of    Points`N field. You can select this number to     be as low as 50 or as high as the number of       points acquired. Starting with the first point    of a source, the 7200 uses every n-th point,      where n depends on the timebase, the number of    points in the source, and the value selected      for Max # Of Points.                                                                              Constants in Trace Equations                          One multiplicative constant and one additive    constant are associated with each source. To      specify these constants press the `MAdd           Constants`N softkey. The display changes to       show the highlighted constants as:                                                                      T1 = (`M`BA1`O`N)                                                                                   Max # Of Points  `M50000`N                                                                           = `M1.0000  -`N    = `M0.0000`N                                                            The `MAdd Constants`N softkey is then           re-labelled as `MDelete Constants.`N Pressing     the `MDelete Constants`N softkey will remove      the constants from that source and save it in     memory. The box may then be moved onto another    source and pressing `MAdd Constants`N will        retieve the previously deleted constants. This    method may be used to move constants from         source to source without re-entering the data.    When any of the constants have changed from       their reset values, the equation will change      to display the greek representations of the       constants:                                                                                              T1 = (*`MA1`N+)                                                                                   Max # Of Points  `M50000`N                                                                           = `M`B1.0001`O  -`N    = `M0.0000`N                                                        Additive or Multiplicative Constants are        split into a mantissa and an exponent which       may be set independently or the mantissa may      be set by itself, in which case the exponent      will follow it. This allows a wide dynamic        range (  to ) while also permitting         entry of precise mantissa values.               Reset Value                                           Press the `MReset Value`N softkey to set the    current field to its default value. If            non-trivial values are selected, these            constants remain displayed in the trace           equation.                                           Since a trace equation may include three        sources, three pairs of constants may be          specified. Different Greek letters are used       for each of the six constants:                                                                      T4 = ((*`MA1`N+)+((*`MT2`N+)+(*`MT3`N+))                                                       = `M1.5000  -`N        = `M0.1000`N         = `M2.5000  -`N        = `M`B0.2000`O`N     = `M3.5000  -`N        = `M0.3000`N                                                        Units for the Constants                               Pressing `MEdit Constants`N also allows         selection of a unit which will get multiplied     by the sources unit. The item next to the         multiplicative constant, allows selection of      the unit for this source. In the above            example, the "-" means that the units are         dimensionless. The user may select the            following units:                                                                                      NAME   DESCRIPTION        NAME  DESCRIPTION      ------ -------------      ------ ------------        -    Dimensionless        s    Second             %    Percent              C    Coulomb           dB    Decibel              F    Farad            dBM    Decibel Milliwatt        Ohm              dBV    Decibel Millivolt    V    Volt          octave    Octave               W    Watt             ppm    Parts per Million    H    Henry              #    Event               WB    Weber              m    Meter                N    Newton             K    Degrees Kelvin       J    Joule            cyc    cycle            POISE    Poise              A    Ampere               g    Gram              Hz    Hertz                                                                                        Press the `MReturn`N softkey to save the        constants entered. Press the `MCancel             Changes`N softkey to restore the constants to     what they were before any changes were made.    Trace Label                                           A trace label is used by the 7200 to to         create filenames for storing the trace. If you    specify a label other then the default ones       (ie. "Trace1", "Trace2", etc), it is printed      on the screen next to the key corresponding to    that trace. To assign a label other than the      default, move the box onto the Trace Label        Field and press the `MEdit Text`N softkey.        When the default label is chosen, the trace       equation will overwrite the label for this        trace. When the label is different than the       default label, trace label will overwrite the     label for this trace. This is useful if you       want informative data to appear in the trace      label for hardcopies.                         Annotate Trace                                          You can annotate up to 10 different points      of interest on a trace. The annotation is         associated with a trace and moves along with      the trace as it is repositioned on the screen.    The text is saved with the trace if it is         stored to disk or read out of the 7200 via a      remote port. It is also useful for generating     hardcopy reports. To display the Trace            Annotation Setup screen, press the `MAnnotate     Trace`N softkey in the Trace Setup screen.          In this screen, there are two fields for        each of the 10 strings you can associate with     a trace. The first field selects whether or       not the string should be displayed. The second    field is the text for the string. When you        move the box onto the text field, the `MEdit      Text`N softkey will appear. When it is            pressed, the box will move on individual          characters in the string to allow you to          modify the annotation. Pressing the `MReturn`N    softkey will save the annotation string.            To reposition the text anywhere within the      grid, press the `MMove Annotation`N softkey. A    horizontal and vertical cursor appear on the      grid. The detented knob under the center of       the screen is used to select which cursor to      move. The center continuous knob is used to       move the selected cursor around on the screen.    The beginning of the selected text will be        placed at the intersection of the two cursors.    When you have positioned the text where you       want it, press the `MReturn`N key to save the     changes and return to the Trace Annotation        Setup screen or `MCancel Changes`N to restore     it to its previous position.                        To exit the Trace Annotation Setup screen,      press the `MReturn`N softkey to save the          annotation entered. Press the `MCancel            Changes`N softkey to restore the annotation to    what it was before any changes were made.     Display Trig Times                                      The `MDisplay Trig Times`N softkey will         display the time(s) at which the trigger(s)       occurred. For Sequence trigger mode, the first    and last trigger times (or Duration) are          displayed along with the trigger time for each    segment. When there are more segment trig         times than can fit on the screen, the `MNext      Line`N continuous knob will allow scrolling up    and down the list of trig times.                    The `MShow Absolute/Relative Times`N softkey    will switch between the display of trig times     from the time at which trigger                    occurred(Absolute) and the time from first        trigger(Relative). The `MReturn`N softkey when    pressed will exit the trig times screen and       return to the `MTrace Setup`N screen.         